/*
 * Decompiled with CFR 0.152.
 */
package apicore.ptmp;

import apicore.message.AuthChallengeLTV;
import apicore.message.AuthRequestLTV;
import apicore.message.AuthResponseLTV;
import apicore.message.AuthStatusLTV;
import apicore.message.BooleanValue;
import apicore.message.LTV;
import apicore.message.StringValue;
import apicore.ptmp.ConnectionNegotiationProperties;
import apicore.ptmp.PacketTracerSession;
import apicore.util.Logger;
import apicore.util.Utilities;
import java.security.MessageDigest;

public class AuthenticationTask {
    private PacketTracerSession packetTracerSession;
    private String app_id = "";
    private String shared_secret = "";
    private int auth_type;

    public AuthenticationTask(PacketTracerSession packetTracerSession) {
        this.packetTracerSession = packetTracerSession;
        ConnectionNegotiationProperties connectionNegotiationProperties = packetTracerSession.connection().connectionNegotiationProperties();
        this.auth_type = connectionNegotiationProperties.getAuthentication();
        this.app_id = connectionNegotiationProperties.getAuthenticationApplication();
        this.shared_secret = connectionNegotiationProperties.getAuthenticationSecret();
        Logger.info("app_id = " + this.app_id);
        Logger.info("shared_secret = " + this.shared_secret);
    }

    public boolean authenticate() throws Exception {
        AuthRequestLTV authRequestLTV = new AuthRequestLTV(new StringValue(this.app_id));
        AuthChallengeLTV authChallengeLTV = (AuthChallengeLTV)this.packetTracerSession.writeRead(authRequestLTV);
        String string = ((StringValue)authChallengeLTV.getValue()).value();
        boolean bl = false;
        String string2 = "Authentication error";
        String string3 = null;
        if (Logger.isInfoEnabled()) {
            Logger.info("Received auth challenge from server: [" + string + "]");
        }
        AuthResponseLTV authResponseLTV = null;
        LTV lTV = null;
        switch (this.auth_type) {
            case 1: {
                string3 = this.shared_secret;
                break;
            }
            case 2: {
                string3 = AuthenticationTask.generateSimpleHash(this.shared_secret);
                break;
            }
            case 4: {
                string3 = AuthenticationTask.generateCrypt(string, this.shared_secret);
                break;
            }
            default: {
                string2 = "Unknown authentication method.";
            }
        }
        Logger.info("digest = " + string3);
        authResponseLTV = new AuthResponseLTV(this.app_id, string3);
        lTV = this.packetTracerSession.writeRead(authResponseLTV);
        if (lTV != null) {
            switch (lTV.getType()) {
                case 7: {
                    string2 = "Authentication terminated by disconnect";
                    break;
                }
                case 5: {
                    BooleanValue booleanValue = (BooleanValue)((AuthStatusLTV)lTV).getValue();
                    bl = booleanValue.value();
                    string2 = "Authentication status: " + bl;
                    break;
                }
                default: {
                    string2 = "Unknown return type from authentication request";
                }
            }
        }
        if (Logger.isInfoEnabled()) {
            Logger.info(string2);
        }
        return bl;
    }

    private static byte[] generateBinaryCrypt(String string, String string2) {
        byte[] byArray = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            messageDigest.update(string2.getBytes());
            byArray = messageDigest.digest();
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage(), exception);
        }
        if (Logger.isInfoEnabled()) {
            Logger.info("Generated MD5: [" + byArray + "]");
        }
        return byArray;
    }

    private static String generateCrypt(String string, String string2) {
        String string3;
        String string4 = null;
        byte[] byArray = AuthenticationTask.generateBinaryCrypt(string, string2);
        if (byArray != null && byArray.length == 16 && (string3 = Utilities.encodeHex(byArray)).length() == 32) {
            string4 = string3.toUpperCase();
        }
        if (Logger.isInfoEnabled()) {
            Logger.info("Generated MD5 string: [" + string4 + "]");
        }
        return string4;
    }

    private static String generateSimpleHash(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = string.getBytes();
        if (byArray != null) {
            for (byte by : byArray) {
                stringBuffer.append((char)(158 - by));
            }
        }
        if (Logger.isInfoEnabled()) {
            Logger.info("Generated hash string: [" + stringBuffer.toString() + "]");
        }
        return stringBuffer.toString();
    }
}

